<div class="w-full p-5 mb-5 ts-gray-2 rounded-lg transition-all rescron-card hidden" id="deposit">
    <h3 class="capitalize  font-extrabold "><span class="border-b-2">Deposit Setting</span>
    </h3>




    <div class="w-full">
        <div class="grid grid-cols-1 gap-3 mt-5">


            <form action="<?php echo e(route('admin.settings.deposit')); ?>" method="POST" class="mt-5 gen-form" data-action="none"
                enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="grid grid-cols-1 gap-5">
                    <p class="text-orange-500 text-xs">*NP = Now Payment</p>
                    <div class="relative">
                        <input type="text" name="np_api_key" placeholder="NP API KEY" id="np_api_key"
                            class="theme1-text-input pl-3" required value="<?php echo e(demoMask(env('NP_API_KEY'))); ?>">
                        <label for="name" class="placeholder-label text-gray-300 ts-gray-2 px-2">NP API KEY</label>
                        <span class="text-xs text-red-500">
                            <?php $__errorArgs = ['np_api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <?php echo e($message); ?>

                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </span>
                    </div>

                    <div class="relative">
                        <input type="text" name="np_secret_key" placeholder="NP SECRET KEY" id="np_secret_key"
                            class="theme1-text-input pl-3" required value="<?php echo e(demoMask(env('NP_SECRET_KEY'))); ?>">
                        <label for="name" class="placeholder-label text-gray-300 ts-gray-2 px-2">NP SECRET
                            KEY</label>
                        <span class="text-xs text-red-500">
                            <?php $__errorArgs = ['np_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <?php echo e($message); ?>

                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </span>
                    </div>


                    <p class="text-orange-500 text-xs">*CP = Coinpayment</p>
                    <div class="relative">
                        <input type="text" name="cp_public_key" placeholder="CP Public Key" id="cp_public_key"
                            class="theme1-text-input pl-3" required value="<?php echo e(demoMask(env('COINPAYMENT_PUBLIC_KEY'))); ?>">
                        <label for="cp_public_key" class="placeholder-label text-gray-300 ts-gray-2 px-2">CP Public Key</label>
                        <span class="text-xs text-red-500">
                            <?php $__errorArgs = ['cp_public_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <?php echo e($message); ?>

                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </span>
                    </div>

                    <div class="relative">
                        <input type="text" name="cp_private_key" placeholder="CP Private Key" id="cp_private_key"
                            class="theme1-text-input pl-3" required value="<?php echo e(demoMask(env('COINPAYMENT_PRIVATE_KEY'))); ?>">
                        <label for="cp_private_key" class="placeholder-label text-gray-300 ts-gray-2 px-2">CP Private Key</label>
                        <span class="text-xs text-red-500">
                            <?php $__errorArgs = ['cp_private_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <?php echo e($message); ?>

                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </span>
                    </div>


                    <div class="relative">
                        <input type="text" name="cp_merchant_id" placeholder="CP Merchant ID" id="cp_merchant_id"
                            class="theme1-text-input pl-3" required value="<?php echo e(demoMask(env('COINPAYMENT_MARCHANT_ID'))); ?>">
                        <label for="cp_merchant_id" class="placeholder-label text-gray-300 ts-gray-2 px-2">CP Merchant ID</label>
                        <span class="text-xs text-red-500">
                            <?php $__errorArgs = ['cp_merchant_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <?php echo e($message); ?>

                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </span>
                    </div>

                    <div class="w-full md:w-1/2">
                        <div class="relative">


                            <select name="payment_processor" id="payment_processor" class="theme1-text-input pl-3" required>
                                <option value="coinpayment" <?php if(site('payment_processor') == 'coinpayment'): ?> selected <?php endif; ?>> Coinpayment </option>
                                <option value="nowpayment" <?php if(site('payment_processor') == 'nowpayment'): ?> selected <?php endif; ?>> NowPayment </option>
                                <option disabled> More Coming Soon...</option>
                            </select>
                            <label for="payment_processor" class="placeholder-label text-gray-300 ts-gray-2 px-2">Payment Processor</label>
                        </div>
                    </div>


                    <div class="relative grid grid-cols-1 lg:grid-cols-3 gap-5">

                        <div class="relative">
                            <input type="number" step="any" name="min_deposit" placeholder="Min Deposit"
                                id="min_deposit" class="theme1-text-input pl-3" required
                                value="<?php echo e(site('min_deposit')); ?>">
                            <label for="min_deposit" class="placeholder-label text-gray-300 ts-gray-2 px-2">Min Deposit
                                (<?php echo e(site('currency')); ?>)</label>
                            <span class="text-xs text-red-500">
                                <?php $__errorArgs = ['min_deposit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <?php echo e($message); ?>

                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </span>
                        </div>

                        <div class="relative">
                            <input type="number" step="any" name="max_deposit" placeholder="Max Deposit"
                                id="max_deposit" class="theme1-text-input pl-3" required
                                value="<?php echo e(site('max_deposit')); ?>">
                            <label for="max_deposit" class="placeholder-label text-gray-300 ts-gray-2 px-2">Max Deposit
                                (<?php echo e(site('currency')); ?>)</label>
                            <span class="text-xs text-red-500">
                                <?php $__errorArgs = ['max_deposit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <?php echo e($message); ?>

                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </span>
                        </div>

                        <div class="relative">
                            <input type="number" step="any" name="deposit_fee" placeholder="Deposit Fee"
                                id="deposit_fee" class="theme1-text-input pl-3" required
                                value="<?php echo e(site('deposit_fee')); ?>">
                            <label for="deposit_fee" class="placeholder-label text-gray-300 ts-gray-2 px-2">Deposit Fee
                                (%)</label>
                            <span class="text-xs text-red-500">
                                <?php $__errorArgs = ['deposit_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <?php echo e($message); ?>

                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </span>
                        </div>


                    </div>


                    <div class="mt-5">

                        <div class="flex justify-end mb-5">
                            <div class="grid grid-cols-1 mb-2 mt-5 w-60">
                                <div class="relative">

                                    <span class="theme1-input-icon material-icons">
                                        search
                                    </span>
                                    <input type="text" placeholder="Search Coins" id="deposit-coin-search-input"
                                        class="theme1-text-input">
                                    <label for="deposit-coin-search-input"
                                        class="placeholder-label text-gray-300 ts-gray-2 px-2">Search Coins
                                    </label>

                                </div>
                            </div>
                        </div>

                        <div class="w-full grid grid-cols-1 md:grid-cols-2 gap-3 mb-5 h-72 overflow-y-scroll overflow-x-hidden px-3 py-10"
                            id="deposit-coins">

                            <?php $__currentLoopData = $deposit_coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div data-target="<?php echo e('deposit_' . $coin->code); ?>" 
                                    class="ts-gray-3  rounded-lg border border-slate-800 hover:border-slate-600 cursor-pointer deposit-coin"
                                    data-label="<?php echo e('deposit_coin_label' . $coin->id); ?>">
                                    <div class="relative deposit_coin_select <?php if($coin->status == 0): ?> hidden <?php endif; ?>"
                                        id="<?php echo e('deposit_' . $coin->code); ?>">
                                        <div
                                            class="absolute flex justify-center items-center -top-1 -right-1 h-6 w-6 rounded-full bg-purple-500 text-white">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="currentColor"
                                                class="bi bi-check2-circle" viewBox="0 0 16 16">
                                                <path
                                                    d="M2.5 8a5.5 5.5 0 0 1 8.25-4.764.5.5 0 0 0 .5-.866A6.5 6.5 0 1 0 14.5 8a.5.5 0 0 0-1 0 5.5 5.5 0 1 1-11 0z" />
                                                <path
                                                    d="M15.354 3.354a.5.5 0 0 0-.708-.708L8 9.293 5.354 6.646a.5.5 0 1 0-.708.708l3 3a.5.5 0 0 0 .708 0l7-7z" />
                                            </svg>
                                        </div>
                                    </div>
                                    <div class="p-5">
                                        <div class="text-gray-500 font-mono font-semibold text-center">
                                            <?php echo e($coin->name); ?>

                                        </div>
                                        <div class="px-2 flex item-center justify-between">
                                            <div class="font-extrabold flex items-center space-x-1">
                                                <img class="w-5 h-5"
                                                    src="<?php echo e('https://nowpayments.io' . $coin->logo_url); ?>"
                                                    alt="">
                                                <span><?php echo e($coin->code); ?></span>
                                            </div>
                                            <?php if($coin->network): ?>
                                                <div>
                                                    <div
                                                        class="px-2 py-1 rounded-lg ts-gray-1 text-xs border border-slate-800 hover:border-slate-600">
                                                        <?php echo e($coin->network); ?>

                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>

                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                        </div>





                    </div>



                </div>

                <div class="text-blue-500 hidden">
                    <?php $__currentLoopData = $deposit_coins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div>
                            <input type="checkbox" value="<?php echo e($coin->id); ?>" name="deposit_coins[]"
                                id="<?php echo e('deposit_check_' . $coin->code); ?>"
                                <?php if($coin->status == 1): ?> checked <?php endif; ?>>
                            <label for="<?php echo e('deposit_check_' . $coin->code); ?>" id="<?php echo e('deposit_coin_label' . $coin->id); ?>"><?php echo e($coin->code); ?></label>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>





                <div class="w-full grid grid-cols-1 gap-5 mt-10 mb-10">
                    <button type="submit" class="bg-purple-500 px-2 py-1 rounded-full transition-all">Save
                        Changes </button>
                </div>

            </form>

        </div>


    </div>

</div>


<?php $__env->startPush('scripts'); ?>
    <script>
        // select the deposit coin
        $(document).on('click', ".deposit-coin", function(e) {
            var target = '#' + $(this).data('target');
            $(target).toggleClass('hidden');
            var label = '#' + $(this).data('label');
            $(label).click();

        });


        // filter the coins
        $(document).on('input keyup', '#deposit-coin-search-input', function() {
            var searchText = $(this).val().toLowerCase();

            $('.deposit-coin').hide().filter(function() {
                return $(this).text().toLowerCase().includes(searchText);
            }).show();
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\Users\Hp\OneDrive\Desktop\projects\laravel\rescron\resources\views/admin/settings/deposit.blade.php ENDPATH**/ ?>